

//
// PB: I use tint_ or Tint_ prefix to avoid collisions with other modules
//

#ifndef TINT_USE_TINT_ALWAYS
SPECIALISATION_PARAM( tint_useTint, "Use [Variance]?", "TINT_USE_TINT" )	
#else
#define TINT_USE_TINT
static const bool tint_useTint = true;
#endif


SPECIALISATION_PARAM( tint_useMaskNorm, "[Variance] Normalize mask in the shader?", "TINT_USE_MASK_NORM" )	
#if defined( _3DSMAX_ ) || defined( TINT_USE_TINT )
DEPENDENT_TEXTURE_PARAM( tint_maskTexture, "[Variance] Mask Texture", tint_useTint )
#endif

SPECIALISATION_PARAM_DEFAULTS_TRUE( tint_useSimpe, "[Variance] Use color multiplication tint?", "TINT_USE_SIMPLE" )
SPECIALISATION_PARAM( tint_use2x, "[Variance] Use 2x color multiplication tint?", "TINT_USE_2X" )	
SPECIALISATION_PARAM( tint_useSignedAditive, "[Variance] Use signed aditive blend mode?", "TINT_USE_SIGNED_ADD" )	
SPECIALISATION_PARAM( tint_useHardLight, "[Variance] Use hard light blend mode?", "TINT_USE_HARD_LIGHT" )	

#if defined( _3DSMAX_ ) || defined( TINT_USE_TINT )
	DEPENDENT_COLOURPICKER_PARAM_DEFAULTED( tint_tintR, "[Variance] Tint Red Mask", tint_useTint, 0.5f, 0.5f, 0.5f, 1.0f  )
	DEPENDENT_COLOURPICKER_PARAM_DEFAULTED( tint_tintG, "[Variance] Tint Green Mask", tint_useTint, 0.5f, 0.5f, 0.5f, 1.0f  )
	DEPENDENT_COLOURPICKER_PARAM_DEFAULTED( tint_tintB, "[Variance] Tint Blue Mask", tint_useTint, 0.5f, 0.5f, 0.5f, 1.0f  )

	sampler2D tint_maskMap : SAMPLER 
	< 
		SET_SRGB_TEXTURE
		bool appEdit = false; 
		string SamplerTexture="tint_maskTexture"; 
		string MinFilter = "Linear";
		string MagFilter = "Linear";
		string MipFilter = "Linear";
		string AddressU  = "Wrap";
		string AddressV  = "Wrap";
		int MipMapLODBias = 0;
	> 
	= sampler_state
	{
		Texture = < tint_maskTexture >;
	#if defined(SET_FX_SAMPLER_STATES)
		FX_SAMPLERSTATE_SRGB_TEXTURE
		MinFilter = _MINFILTER;
		MagFilter = Linear;
		MipFilter = Linear;
		AddressU  = Wrap;
		AddressV  = Wrap;
	#if defined(_PS3_)
		LODBias = 0;
	#else
		MipMapLODBias = 0;
	#endif
		SET_NO_ANISOTROPY
	#endif
	};
#endif



float3 Tint_HardLightBlend( float3 surface, float3 tint )
{
    // PB: TODO: this is hard light blend but our artists probably will settle for something simpler in the end
    return ( tint > 0.5 ) ?  (2*tint + 2*surface - 1 - 2*tint*surface) : (2*tint*surface);
}

float Tint_CalculateLuminance( float3 rgb )
{
	return dot( rgb, float3( 0.33, 0.55, 0.26 ) );
}

float4 Tint_DoIfEnabledEx(float4 hiresColour, float2 maskTexCoord, float3 tintR, float3 tintG, float3 tintB, uniform bool lowDetail)
{
	DEPENDENT_CODE_START( tint_useTint )
	#if defined( _3DSMAX_ ) || defined( TINT_USE_TINT )
		
		float3 mask = tex2D( tint_maskMap, maskTexCoord ).rgb;
		// normalize the mask
		DEPENDENT_CODE_START( tint_useMaskNorm )
		#if defined( _3DSMAX_ ) || defined( TINT_USE_MASK_NORM )
			float maskSum = dot( mask, float3( 1, 1, 1 ) );
			if( maskSum > 1e-4 )
			{
				mask = mask / maskSum;
			}
		#endif
		DEPENDENT_CODE_END( tint_useMaskNorm )
		
		
		float3 redColour = 1;
		float3 greenColour = 1;
		float3 blueColour = 1;

		DEPENDENT_CODE_START( tint_useSimpe )
		#if defined( _3DSMAX_ ) || defined( TINT_USE_SIMPLE )
			redColour		= tintR * hiresColour;
			greenColour	= tintG * hiresColour;
			blueColour  = tintB * hiresColour;
		#endif
		DEPENDENT_CODE_ELSE( tint_useSimpe )
		#if defined( _3DSMAX_ ) || !defined( TINT_USE_SIMPLE )
			DEPENDENT_CODE_START( tint_use2x )
			#if defined( _3DSMAX_ ) || defined( TINT_USE_2X )
			redColour		= 2.0 * tintR * hiresColour;
			greenColour	= 2.0 * tintG * hiresColour;
			blueColour  = 2.0 * tintB * hiresColour;
			#endif
			DEPENDENT_CODE_ELSE( tint_use2x )
			#if defined( _3DSMAX_ ) || !defined( TINT_USE_2X )
				
				DEPENDENT_CODE_START( tint_useSignedAditive )
				#if defined( _3DSMAX_ ) || defined( TINT_USE_SIGNED_ADD )
					redColour		= hiresColour + tintR - 0.5;
					greenColour	= hiresColour + tintG - 0.5;
					blueColour  = hiresColour + tintB - 0.5;
				#endif
				DEPENDENT_CODE_ELSE( tint_useSignedAditive )
				#if defined( _3DSMAX_ ) || !defined( TINT_USE_SIGNED_ADD )

					DEPENDENT_CODE_START( tint_useHardLight )
					#if defined( _3DSMAX_ ) || defined( TINT_USE_HARD_LIGHT )
					
						float3 blendedTint = mask.r * tintR.rgb + mask.g * tintG.rgb + mask.b * tintB.rgb;
						redColour		= Tint_HardLightBlend( hiresColour.rgb, blendedTint );
						greenColour = redColour;
						blueColour	= redColour;
						
					#endif
					DEPENDENT_CODE_END( tint_useHardLight )

				#endif
				DEPENDENT_CODE_END( tint_useSignedAditive )

			#endif
			DEPENDENT_CODE_END( tint_use2x )
		#endif	
		DEPENDENT_CODE_END( tint_useSimpe )
		
		
		//
		// now tint the original texture
		//		
		hiresColour.rgb		= mask.r * redColour + mask.g * greenColour + mask.b * blueColour + saturate( 1 - dot(mask, float3(1,1,1)) ) * hiresColour.rgb;

				
	#endif
	DEPENDENT_CODE_END( tint_useTint )
	
	return hiresColour;	
}

float4 Tint_DoIfEnabled(float4 hiresColour, float2 maskTexCoord, uniform bool lowDetail)
{
	DEPENDENT_CODE_START( tint_useTint )
	#if defined( _3DSMAX_ ) || defined( TINT_USE_TINT )
		return Tint_DoIfEnabledEx( hiresColour, maskTexCoord, tint_tintR, tint_tintG, tint_tintB, lowDetail );
	#endif
	DEPENDENT_CODE_ELSE( tint_useTint )
	#if defined( _3DSMAX_ ) || !defined( TINT_USE_TINT )
		return hiresColour;		
	#endif
	DEPENDENT_CODE_END( tint_useTint )
}
